#include "vector.hh"
#include <stdio.h>

template <class T>
class __qwertyuiopasdfghjklzxcvbnm__
{
public:  
  inline void operator=(const T &s) { new (this) T(s); }
};

template <class T>
/*static*/ inline __qwertyuiopasdfghjklzxcvbnm__<T> &Create (T &t) 
              { return *((__qwertyuiopasdfghjklzxcvbnm__<T> *) &t); }

template <class T>
/*static*/ inline void *operator new(size_t, __qwertyuiopasdfghjklzxcvbnm__<T> *v) 
              { return (void *) v; }

template <class T>
void Vector<T>::modify(int cap)
{
  if (*_ref_count > 1 || cap != _cap)
  {
    T *l = _l;
    _cap = cap;
    _l = (T *) new char[sizeof(T[_cap])];
    for (int i=0; i<_n; i++) 
                  Create(_l[i]) = l[i]; // use copy constructor
    if (--*_ref_count) _ref_count = new unsigned long;
    else 
    {
      for (int i=0; i<_n; i++) l[i].~T();
      delete[] (char *) l;  
    }  
    *_ref_count = 1;
  }    
}

template <class T>
void Vector<T>::make(const T &elem)
{
  assert (0 <= _n && _n <= _cap);
  _l = (T *) new char[sizeof(T[_cap])]; // no time-consuming initialization
  for (int i=0; i<_n; i++)              // only necessary initialization
                  Create(_l[i]) = elem; // use copy constructor
  _ref_count = new unsigned long(1);    // use copy constructor
}

template <class T>
void Vector<T>::copy(const Vector<T> &source)
{
  _l = source._l;                 // pointer copy, not array copy
  _n = source._n;
  _cap = source._cap;
  _ref_count = source._ref_count; // pointer copy
  (*_ref_count)++;
}

template <class T>
void Vector<T>::destroy()
{
  if (!--*_ref_count)
  {
    for (int i=0; i<_n; i++) _l[i].~T();
    delete _ref_count;
    delete[] (char *)_l;
  }
}

template <class T>
Vector<T>::Vector(int n, const T &elem)
  : _l(NULL), _n(n), _cap(n), _ref_count(NULL)
{
  make(elem);
}

template <class T>
Vector<T>::Vector(int n, const T &elem, int cap)
  : _l(NULL), _n(n), _cap(cap), _ref_count(NULL)
{
  make(elem);
}

template <class T>
Vector<T>::Vector(const Vector<T> &source)
{
  copy(source);
}

template <class T>
Vector<T>::~Vector()
{
  destroy();
}

template <class T>
Vector<T> Vector<T>::operator=(const Vector<T> &source)
{
  if (this != &source)
  {
    destroy();
    copy(source);
  }  
  return *this;
}

template <class T>
int Vector<T>::size() const
{
  return _n;
}
  
template <class T>
int Vector<T>::capacity() const
{
  return _cap;
}
  
template <class T>
const T &Vector<T>::operator[](int i) const
{
  assert (i >= 0 && i < _n);
  return _l[i];
}

template <class T> 
const T &Vector<T>::back() const
{
  assert (_n > 0);
  return _l[_n-1];
}

template <class T>
T &Vector<T>::operator[](int i)
{
  assert (i >= 0 && i < _n);
  modify();
  return _l[i];
}

template <class T> 
T &Vector<T>::back()
{
  assert (_n > 0);
  modify();
  return _l[_n-1];
}

template <class T> 
void Vector<T>::push_back(const T &elem)
{
  resize(_n+1, elem);
}

template <class T> 
void Vector<T>::pop_back()
{
  resize(_n-1);
}

template <class T> 
void Vector<T>::clear()
{
  resize(0);
}  
  
template <class T> 
void Vector<T>::resize(int n, const T &elem, int cap)
{
  assert(n >= 0 && cap >= 0);
  if (cap < n) resize(n, elem, 2*cap+1);
  else
  {
    modify(cap);
    for (int i=n; i<_n; i++) _l[i].~T();
    for (int i=_n; i<n; i++) 
                  Create(_l[i]) = elem; // use copy constructor
    _n = n;
  }  
}  
  
template <class T> 
void Vector<T>::zero(const T &elem, int i1, int i2)
{
  assert (0 <= i1 && i1 <= i2 && i2 <= _n);
  for (int i=i1; i<i2; i++) _l[i] = elem;
}	  
      
template <class T> 
void Vector<T>::assign(int n, const T &elem, int cap)
{
  resize (0, elem, cap);
  resize (n, elem, cap);
}
      
template <class T> 
void Vector<T>::sort(int (* fncompare)(const T &, const T &), int i, int j)
{ 
  assert (0 <= i && i <= j && j <= _n);
  modify ();
  qsort((void *) (_l + i), j - i, sizeof(T), 
        (int (*)(const void *, const void *)) fncompare); 
}
