#define MAXDEGREE 15	/* maximale graad van een polynoom */

#define sign(x) ((x) < 0 ? -1 : ((x) > 0 ? 1 : 0))	/* het teken van x */
#define abs(x) ((x) < 0 ? -(x) : (x))

typedef struct {
	int degree;
 	double coeff[MAXDEGREE];
} poly;


/* evalpoly evalueert het polynoom f in het punt x */

double evalpoly(poly f,double x)
{int i;double m,s;
m=1;s=f.coeff[0];
for(i=1;i<=f.degree;i++) {m=m*x;s=s+m*f.coeff[i];}
return(s);}


/* diff differentieert een polynoom */

poly diff(poly f)
{poly g;int i;
g.degree=f.degree-1;
for(i=0;i<=g.degree;i++) g.coeff[i]=f.coeff[i+1]*(i+1);
return(g);}


/* binarysolve zoekt een nulpunt van een polynoom f in het interval
[lowerbound,upperbound] onder de voorwaarde dat f(lowerbound) en f(upperbound)
verschillend teken hebben. Het antwoord wijkt niet meer af dan epsilon. */

double binarysolve(poly f,double lowerbound,double upperbound,double epsilon)
{double a,b,c;int sa,sb,sc;
a=lowerbound;b=upperbound;if (b-a<epsilon) return(b);
sa=sign(evalpoly(f,a));sb=sign(evalpoly(f,b));
while (b-a>epsilon)
	{c=(a+b)/2;sc=sign(evalpoly(f,c));
	if (sc==sb) {b=c;sb=sc;} else {a=c;sa=sc;}};
return(b);}


/* Nulpunten zoeken met behulp van de Newton methode onder de aanname
dat f'' geen nulpunten op het interval heeft */

double newton(poly f,poly df,double lowerbound,double upperbound,double epsilon)
{double x,fx,dfx;int i;
/* for(i=0;i<=f.degree;i++) printf("$ %f ",f.coeff[i]);
printf("\n");
for(i=0;i<=df.degree;i++) printf("$ %f ",df.coeff[i]);
printf("\n"); */
if (abs(evalpoly(df,lowerbound))>abs(evalpoly(df,upperbound))) x=lowerbound;
else x=upperbound;
fx=evalpoly(f,x);dfx=evalpoly(df,x);
/* printf("hallo %f, %f, %f\n",fx,dfx,fx/dfx); */
while(abs(fx/dfx)>epsilon) 
{/* printf("%f %f %f\n",x,fx,dfx) */
;x=x-fx/dfx;fx=evalpoly(f,x);dfx=evalpoly(df,x);};
return(x);}


/* het recursieve gedeelte van polysolve2 */

double polysolverec(poly f[MAXDEGREE],double lowerbound, double upperbound, double epsilon,int depth)
{double zerof,zerog;int i;poly g;
g=f[depth];
/* printf("%d, %f, %f\n",depth,lowerbound,upperbound); */
if (sign(evalpoly(g,lowerbound))!=sign(evalpoly(g,upperbound)))
	{zerog=newton(g,f[depth+1],lowerbound,upperbound,epsilon);
	if (depth==0) return(zerog);
	zerof=polysolverec(f,lowerbound,zerog,epsilon,depth-1);
	if (zerof<zerog) return(zerof);
	return(polysolverec(f,zerog,upperbound,epsilon,depth-1));};
if (depth==0) return(upperbound+epsilon);
return(polysolverec(f,lowerbound,upperbound,epsilon,depth-1));}

	 
/* polysolve2: kleinste nulpunt zoeken met Newton & bottom up */

double polysolve2(poly f,double lowerbound, double upperbound, double epsilon)
{poly g[MAXDEGREE+1];int i;
g[0]=f;for(i=0;i<f.degree;i++) g[i+1]=diff(g[i]);
polysolverec(g,lowerbound,upperbound,epsilon,f.degree-1);}
 

/* polysolve1: kleinste nulpunt zoeken met binary search & top down */

double polysolve1(poly f,double lowerbound,double upperbound,double epsilon)
{double a,b,c;
/* printf("%d, %f, %f\n",f.degree,lowerbound,upperbound); */
a=lowerbound;b=upperbound;if (b-a<epsilon) return(b);
if (f.degree==1) 
	{c=-f.coeff[0]/f.coeff[1]; 
	if ((c-epsilon<a) || (c+epsilon>b)) return(b+epsilon);
	return(c);};
c=polysolve1(diff(f),a,b,epsilon);/* printf("%f\n",c); */
if (sign(evalpoly(f,c))!=sign(evalpoly(f,a))) 
	return(binarysolve(f,a,c,epsilon));
return(polysolve1(f,c,b,epsilon));}

