#ifndef BUTTON_HH
#define BUTTON_HH
#include "panel.hh"
#include "alarm.hh"
#include "swwidget.hh"

class Button: public AlarmHooks, public SwWidget {

 private:
 
  Gif_XContext *_gifx;

 protected:
 
  Pixmap _normal;
  Pixmap _normal_mask;
  Pixmap _lit;
  Pixmap _lit_mask;

 private:
  
  int _state;				// 0 off, 1 lit, 2 flashing
  Alarm _flash_alarm;
  
  bool handle_track_event(XEvent *);
  
 public:
  
  Button(SwWindow *);
  
  int get_state() const;
  void change_state(int);

  bool set_normal(Gif_Stream *, const char *);
  bool set_lit(Gif_Stream *, const char *);
  
  void draw();
  
  bool within(int, int) const;
  bool track(Time);

  void flash();
  void alarm();
  
};

class DiagnosisButton: public Button {
  
  Pixmap _unknown;
  Pixmap _unknown_mask;
  Pixmap _winnable;
  Pixmap _winnable_mask;
  Pixmap _impossible;
  Pixmap _impossible_mask;
  Pixmap _partial;
  Pixmap _partial_mask;
  
  int _diagnosis;                       // 0 unknown, 1 winnable, 2 impossible

public:

  DiagnosisButton (SwWindow *);

  int get_diagnosis();
  void change_diagnosis(int);
  
  virtual bool set_normal(Gif_Stream *, const char *);
  bool set_win(Gif_Stream *, const char *);
  bool set_imp(Gif_Stream *, const char *);
  bool set_part(Gif_Stream *, const char *);
  
};

inline void
Button::draw()
{
  clear_area(0, 0, width(), height());
  if (_state > 0)
    draw_image(_lit, _lit_mask, width(), height(), 0, 0);
  else
    draw_image(_normal, _normal_mask, width(), height(), 0, 0);
}

inline bool
Button::within(int xval, int yval) const
{
  return xval >= x() && yval >= y() && xval < x() + width()
    && yval < y() + height();
}

#endif
