#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "matches.hh"

MatchCount::MatchCount(SwWindow *window, Gif_Stream *gfs, const char *name,
  const char *name10)
  : SwWidget(window), _game(0),
    _one_image(None), _one_mask(None), 
    _ten_image(None), _ten_mask(None),
    _count(0), _draw_matches(1), _visible(1)
{
  Gif_Image *gfi = Gif_GetNamedImage(gfs, name);
  if (gfi) {
    Gif_XContext *gifx = get_gif_x_context();
    _one_image = Gif_XImage(gifx, gfs, gfi);
    _one_mask = Gif_XMask(gifx, gfs, gfi);
    _one_width = Gif_ImageWidth(gfi);
    _one_height = Gif_ImageHeight(gfi);
  }
  Gif_Image *gfi10 = Gif_GetNamedImage(gfs, name10);
  if (gfi10) {
    Gif_XContext *gifx = get_gif_x_context();
    _ten_image = Gif_XImage(gifx, gfs, gfi10);
    _ten_mask = Gif_XMask(gifx, gfs, gfi10);
    _ten_width = Gif_ImageWidth(gfi10);
    _ten_height = Gif_ImageHeight(gfi10);
  }
}

void
MatchCount::set_game(Game *g)
{
  assert(!_game);
  _game = g;
  _game->add_hook(this);
}

void
MatchCount::draw(int new_count)
{
  int count1 = (_draw_matches?_count:0), count10 = 0;
  while (count1 * _one_width + count10 * _ten_width > width() && 
         count1 >= 10 || count1 >= 13)
  {
    count1 -= 10;
    count10++;
  }
    
  _draw_matches = _visible;
  
  int new_count1 = (_draw_matches?new_count:0), new_count10 = 0;
  while (new_count1 * _one_width + new_count10 * _ten_width > width() 
         && new_count1 >= 10 || new_count1 >= 13)
  {
    new_count1 -= 10;
    new_count10++;
  }
    
  if (count10 > new_count10)
  {
    clear_area (new_count10 * _ten_width, 0, width(), _ten_height);
    count1 = 0;
  }
  else if (count10 < new_count10)
  {
    if (count1)
    {
      clear_area (count10 * _ten_width, 0, width(), _one_height);
      count1 = 0;
    }  
  }
  else if (count1 > new_count1)
  {
    clear_area (new_count10 * _ten_width + new_count1 * _one_width, 
                0, width(), _one_height);
  }		   

  for (int l=count10; l<new_count10; l++)
  {
    int x = l * _ten_width;
    if (x >= width()) break;
    draw_image(_ten_image, _ten_mask, _ten_width, _ten_height, x, 0);
  }  
    
  for (int m=count1; m<new_count1; m++)
  {
    int x = new_count10 * _ten_width + m * _one_width;
    if (x >= width()) break;
    draw_image(_one_image, _one_mask, _one_width, _one_height, x, 0);
  }

  _count = new_count;
}

void
MatchCount::redraw()
{
  int c = _count;
  draw(0);
  draw(c);
}  

void
MatchCount::start_hook(Game *g)
{
  draw(g->possible_moves());
}

void
MatchCount::move_made_hook(Game *g)
{
  draw(g->possible_moves());
}
