#ifndef MATCHES_HH
#define MATCHES_HH
#include "swwidget.hh"
#include "game.hh"

class MatchCount: public SwWidget, public GameHooks {

  Game *_game;
 
  Pixmap _one_image;
  Pixmap _one_mask;
  int _one_width;
  int _one_height;

  Pixmap _ten_image;
  Pixmap _ten_mask;
  int _ten_width;
  int _ten_height;

  int _count;
  bool _draw_matches;
  bool _visible;
  
 public:
  
  MatchCount(SwWindow *, Gif_Stream *, const char *, const char *);
  
  void set_game(Game *);
  
  void draw(int m);
  void draw()                                   { draw(_count); }
  void redraw();
  
  int count() const                             { return _count; }
  void start_hook(Game *);
  void move_made_hook(Game *);
  bool &visible()                               { return _visible; }
  
};

#endif
