#ifndef VECTOR_HH
#define VECTOR_HH
#include <assert.h>
#include <stdlib.h>

template <class T>
class Vector {
  
  T *_l;
  int _n;
  int _cap;
  unsigned long *_ref_count;
  
  inline void modify()                  { modify(_cap); }
  void modify(int cap);
  void make(const T &elem);
  void copy(const Vector<T> &source);
  void destroy();
  
 public:
  
  explicit Vector(int n=0, const T &elem=T());
  Vector(int n, const T &elem, int cap);
  Vector(const Vector<T> &source);
  ~Vector();
  Vector<T> operator=(const Vector<T> &source);

  
  int size() const;
  int capacity() const;
  
  const T &operator[](int) const;
  const T &back() const;
  
  T &operator[](int);
  T &back();
 
  void push_back(const T &elem=T());
  void pop_back();
  
  void clear();
  inline void resize(int n, const T &elem=T())   { resize(n, elem, _cap); }
  void resize(int n, const T &elem, int cap);
  inline void zero(const T &elem=T(), int i=0)   { zero(elem, i, _n); }
  void zero(const T &elem, int i, int j);
  inline void assign(int n=0, const T &elem=T()) { assign(n, elem, _cap); }
  void assign(int n, const T &elem, int cap);
  
  inline void sort(int (* fncompare)(const T &, const T &), int i=0)
                                                 { sort(fncompare, i, _n); }
  void sort(int (* fncompare)(const T &, const T &), int i, int j);

};

#endif
